<?php
class GecersizNotException extends Exception {
    public function __construct($kod = 1001, Exception $onceki = null) {
        parent::__construct('Not 0-100 arasında olmalı!', $kod, $onceki);
    }
    public function __toString() {
        return __CLASS__ . ": [{$this->code}]: {$this->message}\n";
    }
    public function bilgi(){
        return '<b>Bu istisna sınıfı 0-100 aralığı haricinde bir sınav '.
            'notu girmeniz durumunda oluşur.</b>';
    }
}

function ortalama($vize, $final){
    if(!is_numeric($vize) || !is_numeric($final))
        throw new InvalidArgumentException('Notlar sayısal olmalı');
    if($vize<0 || $vize>100)
        throw new GecersizNotException();
    if($final<0 || $final>100)
        throw new GecersizNotException();
    return ($vize + $final) / 2;
}

$v = 80;
$f = -99;
try {
    printf('Vize=%d<br>Final=%d<br>Ortalama=%.1f',
        $v, $f, ortalama($v, $f));
} catch(InvalidArgumentException $e){
    echo $e->getMessage();
} catch(GecersizNotException $e){
    echo $e.'<br>';
    echo $e->getMessage().'<br>';
    echo $e->bilgi();
} catch(Exception $e){
    echo 'Hata: '.$e->getMessage();
}
